// $Id: CTempoNoteShiftPanel.cpp,v 1.5 2007/02/11 02:20:27 paul Exp $

/*
 * All contents of this source code are copyright 2007 Exp Digital Uk.
 * This file forms part of the example projects for the Infinity API.
 * You may not redistribute either the source code or the compiled binary.
 * The Infinity API is covered by a fair use licence which you should have recieved with this
 * file. If you didnt receieve the licence, please contact us via http://www.expdigital.co.uk
 */

#include "CTempoNoteShiftPanel.hpp"
#include "CSCalWindow.hpp"
using Exponent::SCal::CSCalWindow;
using Exponent::SCal::CTempoNoteShiftPanel;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CTempoNoteShiftPanel, CControlPanel);

//	===========================================================================
CTempoNoteShiftPanel::CTempoNoteShiftPanel(IControlRoot *root, const long uniqueId, const CRect &area)
                    : CControlPanel(root->getParentWindow(), root, uniqueId, area, NULL)
                    , m_tempoNoteShiftBpm1EditBox(NULL)
                    , m_tempoNoteShiftBpm2EditBox(NULL)
                    , m_tempoNoteShiftOutputValueLabel(NULL)
{
	EXPONENT_CLASS_CONSTRUCTION(CTempoNoteShiftPanel);

	this->onDrawDrawThePanelBounds(false);

	// BPM edit
	m_tempoNoteShiftBpm1EditBox		  = new CTextEdit(this,  e_tempoNoteShiftBpm1EditBox,		CSCalWindow::CSCALWINDOW_CONTROL1_RECT, "120.00", this);
	m_tempoNoteShiftBpm2EditBox		  = new CTextEdit(this,  e_tempoNoteShiftBpm2EditBox,		CSCalWindow::CSCALWINDOW_CONTROL2_RECT, "240.00", this);
	m_tempoNoteShiftOutputValueLabel  = new CTextLabel(this, CControl::CCONTROL_NO_ID_REQUIRED, CSCalWindow::CSCALWINDOW_OUTPUTBOX_RECT, CString::CSTRING_EMPTY_STRING);

	// Reference
	m_tempoNoteShiftBpm1EditBox->referenced();
	m_tempoNoteShiftBpm2EditBox->referenced();
	m_tempoNoteShiftOutputValueLabel->referenced();

	// Set the format
	m_tempoNoteShiftBpm1EditBox->setTextFormat(CGraphics::e_centerCenterAlign);
	m_tempoNoteShiftBpm2EditBox->setTextFormat(CGraphics::e_centerCenterAlign);
	m_tempoNoteShiftOutputValueLabel->setTextFormat(CGraphics::e_centerCenterAlign);

	m_tempoNoteShiftBpm1EditBox->setAlignment(CTextEdit::e_center);
	m_tempoNoteShiftBpm2EditBox->setAlignment(CTextEdit::e_center);

	// Make single click editable
	m_tempoNoteShiftBpm1EditBox->setSingleClickEditable();
	m_tempoNoteShiftBpm2EditBox->setSingleClickEditable();

	// Colours
	m_tempoNoteShiftBpm1EditBox->setColours(		CAlphaColour::CALPHACOLOUR_BLACK, CSCalWindow::CSCALWINDOW_BACKGROUND_COLOUR, CSCalWindow::CSCALWINDOW_TEXT_COLOUR);
	m_tempoNoteShiftBpm2EditBox->setColours(		CAlphaColour::CALPHACOLOUR_BLACK, CSCalWindow::CSCALWINDOW_BACKGROUND_COLOUR, CSCalWindow::CSCALWINDOW_TEXT_COLOUR);
	m_tempoNoteShiftOutputValueLabel->setColours(	CAlphaColour::CALPHACOLOUR_BLACK, CAlphaColour::CALPHACOLOUR_WHITE, CSCalWindow::CSCALWINDOW_ANSWER_TEXT_COLOUR);

	// Add controls
	this->addControl(m_tempoNoteShiftBpm1EditBox);
	this->addControl(m_tempoNoteShiftBpm2EditBox);
	this->addControl(m_tempoNoteShiftOutputValueLabel);

	// Compute
	this->computeTempoNoteShift();
}

//	===========================================================================
CTempoNoteShiftPanel::~CTempoNoteShiftPanel()
{
	EXPONENT_CLASS_DESTRUCTION(CTempoNoteShiftPanel);

	FORGET_COUNTED_OBJECT(m_tempoNoteShiftBpm1EditBox);
	FORGET_COUNTED_OBJECT(m_tempoNoteShiftBpm2EditBox);
	FORGET_COUNTED_OBJECT(m_tempoNoteShiftOutputValueLabel);
}

//	===========================================================================
void CTempoNoteShiftPanel::handleActionEvent(const CActionEvent &event)
{
	switch(event.getControl()->getUniqueId())
	{
		case e_tempoNoteShiftBpm1EditBox:
		case e_tempoNoteShiftBpm2EditBox:
			this->computeTempoNoteShift();
		break;
	}
}

//	===========================================================================
void CTempoNoteShiftPanel::computeTempoNoteShift()
{
	double bpm1 = CString::toDouble(m_tempoNoteShiftBpm1EditBox->getString().getString());
	double bpm2 = CString::toDouble(m_tempoNoteShiftBpm2EditBox->getString().getString());

	if (bpm1 <= 0.0 || bpm1 >= 1000.0)
	{
		CDialog::notifyUser("BPM # 1 range error!\n\n0 < bpm < 1000\n\nBpm must be between 0 and 1000 bpm", "SCal error", true);
		bpm1 = 120.0;
		m_tempoNoteShiftBpm1EditBox->setText("120.00");
		m_tempoNoteShiftBpm1EditBox->update();
	}
	else
	{
		CString string;
		string.setStringWithFormat("%0.02f", bpm1);
		m_tempoNoteShiftBpm1EditBox->setText(string);
		m_tempoNoteShiftBpm1EditBox->update();
	}
	if (bpm2 <= 0.0 || bpm2 >= 1000.0)
	{
		CDialog::notifyUser("BPM # 2 range error!\n\n0 < bpm < 1000\n\nBpm must be between 0 and 1000 bpm", "SCal error", true);
		bpm2 = 120.0;
		m_tempoNoteShiftBpm2EditBox->setText("120.00");
		m_tempoNoteShiftBpm2EditBox->update();
	}
	else
	{
		CString string;
		string.setStringWithFormat("%0.02f", bpm2);
		m_tempoNoteShiftBpm2EditBox->setText(string);
		m_tempoNoteShiftBpm2EditBox->update();
	}

	CString output;
	output.setStringWithFormat("%0.02f", CMusicMath::getTempoNoteShift(bpm1, bpm2));
	m_tempoNoteShiftOutputValueLabel->setText(output);
	m_tempoNoteShiftOutputValueLabel->update();
}